--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: New York
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "ny_factorykeep" }
DefineCharacter { name = "ny_marketkeep"}
DefineCharacter { name = "ny_shopkeep" }
DefineCharacter { name = "ny_barkeep" }
DefineCharacter { name = "ny_librarykeep" }
DefineCharacter { name = "ny_gambler01b", appearance = "gambler", action = Speak { "ny_gambler01_speak01"}, }
DefineCharacter { name = "ny_gambler01", appearance = "gambler", action = {PlayDice(), PlayBonus()}, }
DefineCharacter { name = "ny_gambler02", appearance = "lender", action = {PlayDice(), PlayBonus()}, }
DefineCharacter { name = "ny_gambler03", appearance = "traveler03", action = {PlayDice(), PlayBonus()}, }
DefineCharacter { name = "ny_gambler04", appearance = "villain02", action = {PlayDice(), PlayBonus()}, }
DefineCharacter { name = "ny_gambler05", appearance = "villain03", action = {PlayDice(), PlayBonus()},}

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "newyork",
	available = false,
	ambient = "sfx/metropolitan_loop.ogg",
	
	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_02", time=150000, loop=true, htile=true, path={{800,70},{700,70},{100,70},{0,70}}, },
		
		-- Planes
-- 911 sensitivity
--		SpriteLayer { imagelist=portPlanes, scale=.15,
--			path={{-72,-4},{8,85},{150,86},{503,19},{641,-8},{688,60},{845,49},}, },
			
		SpriteLayer { image="ny_leftskyline", x=128,y=118 },
		SpriteLayer { image="ny_rightskyline", x=579,y=108 },
		
		--Chrysler building
		
		SpriteLayer { image="ny_chrysler_construction_1", x=115,y=118,startweek=65,endweek=179, },
		SpriteLayer { image="ny_chrysler_construction_2", x=115,y=118,startweek=180,endweek=261, },
		SpriteLayer { image="ny_chrysler", x=115,y=118,startweek=262, },

		--Empire State building
		SpriteLayer { image="ny_empire_construction_1", x=630,y=121,startweek=108,endweek=221, },
		SpriteLayer { image="ny_empire_construction_2", x=630,y=121,startweek=222,endweek=319, },
		SpriteLayer { image="ny_empire", x=630,y=121,startweek=320, },
		
		Factory { name="ny_factory", character="ny_factorykeep", price = 85000, x=720,y=135, labelx=650,labely=135},
		PlayerLogo { name="logo", x=656+132/2,y=18+75/2, scale=0.30, target="ny_factory" },
		SpriteLayer { image="ny_factorymask", x=696,y=210, },
		
		-- Train
		SpriteLayer { image="train_01", scale=.2, hold=3000,
			path={{-80,238},{100,238},{750,238},{880,238}} },
		SpriteLayer { image="train_01", scale=.2, hold=10000,
			path={{880,239},{750,239},{100,239},{-80,239}} },
		
		SpriteLayer { image="ny_leftmask", x=115,y=222 },
		SpriteLayer { image="ny_rightmask", x=698,y=237 },

		EmptyBuilding { name="ny_bar", character= {"ny_barkeep"}, ambient="sfx/saloon_loop.ogg", x=754,y=212, labelx=735 },
		
		
		SpriteLayer { image="ny_barmask", x=737,y=287, },
		
		--z-axis el trains
		SpriteLayer { image="train_07", near=400,nearscale=4.5, far=255,farscale=0.3, hold=8000,
			path={{853,292},{782,278},{733,265},{657,242},}, },
		SpriteLayer { image="train_06", near=400,nearscale=4.5, far=255,farscale=0.3,
			path={{658,244},{730,269},{798,288},{864,305},}, },
		
			
		SpriteLayer { image="ny_trainmask", x=737,y=287, },
		SpriteLayer { image="ny_trainmask_2", x=662,y=269, },
		
		Speakeasy { name="ny_den", x=211,y=264, ambient="sfx/saloon_loop.ogg",
			rank0 = {"ny_gambler01b"},
			rank4 = {"ny_gambler01", "ny_gambler02", "ny_gambler03", "ny_gambler04", "ny_gambler05"}, },
		SpriteLayer { image="ny_denmask", x=224,y=266, },
		Market { name="ny_market", character="ny_marketkeep", x=264,y=173,
			inventory = { pecan=true, milk=true, sugar=true, cashew=true, mint = true, } },
		GenericBuilding { name="ny_library", character="ny_librarykeep", ambient="sfx/other_loop.ogg", x=560,y=255, },
		Shop { name="ny_shop", character="ny_shopkeep", x=410,y=198, labelx=390,labely=214 },
		
		-- Cars, Trolley on left
		SpriteLayer { image="car_07", near=400,nearscale=.45, far=255,farscale=0.1, hold=4000,
			path={{201,650},{158,483},{123,338},{102,257}} },
		SpriteLayer { image="car_12", near=400,nearscale=.45, far=255,farscale=0.1,
			path={{99,260},{107,339},{120,491},{136,653}} },
		SpriteLayer { image="train_08", near=400,nearscale=0.65, far=255,farscale=0.1,
			path={{113,267},{143,314},{212,452},{325,659}} },
		SpriteLayer { image="car_07", near=400,nearscale=.45, far=255,farscale=0.1, hold=2500,
			path={{460,630},{280,430},{164,313},{122,266}} },
		SpriteLayer { image="car_12", near=400,nearscale=.45, far=255,farscale=0.1, 
			path={{121,267},{164,315},{262,431},{406,612}} },

		-- Cars on right
		SpriteLayer { image="car_12", near=400,nearscale=.45, far=250,farscale=0.1,
			path={{645,262},{673,307},{743,413},{843,579}} },
		SpriteLayer { image="car_07", near=400,nearscale=.45, far=250,farscale=0.1, hold=1500,
			path={{782,630},{709,420},{661,307},{638,260}} },
		
			
	},
}
